#!/bin/sh

###############################################################################
# URL of the ZIP file to download

DOWNLOAD_URL="deployment link"

# Define the download and extraction locations
DOWNLOAD_DIR="$HOME/Downloads"
ZIP_FILE="$DOWNLOAD_DIR/customerPluginZA.zip"
EXTRACT_DIR="$DOWNLOAD_DIR/customerPluginZA"

# Download the ZIP file
echo "Downloading ZIP file from $DOWNLOAD_URL..."
curl -L "$DOWNLOAD_URL" -o "$ZIP_FILE"

# Create the extraction directory
rm -r "$EXTRACT_DIR"
mkdir -p "$EXTRACT_DIR"

# Unzip the file into the extraction directory
echo "Unzipping the file..."
unzip -q "$ZIP_FILE" -d "$EXTRACT_DIR"

# Find the .pkg file in the extracted directory
PKG_FILE=$(find "$EXTRACT_DIR" -name "*.pkg" | head -n 1)

if [ -z "$PKG_FILE" ]; then
    echo "No .pkg file found in the extracted folder."
    exit 1
fi

# Install the .pkg file
echo "Installing $PKG_FILE..."
sudo installer -pkg "$PKG_FILE" -target /

## Clean up
#echo "Cleaning up..."
rm -f "$ZIP_FILE"
rm -rf "$EXTRACT_DIR"

echo "Installation complete."
