//$Id$
package com.handlers;

import java.util.Map;

import org.json.JSONObject;

import com.zc.cliq.objects.FormChangeResponse;
import com.zc.cliq.objects.FormDynamicFieldResponse;
import com.zc.cliq.objects.MessageBuilder;
import com.zc.cliq.requests.ButtonFunctionRequest;
import com.zc.cliq.requests.FormFunctionRequest;
import com.zc.cliq.requests.WidgetFunctionRequest;
import com.zc.cliq.util.ZCCliqUtil;
import com.zc.component.object.ZCObject;
import com.zc.component.object.ZCRowObject;
import com.zc.component.object.ZCTable;

public class FunctionHandler implements com.zc.cliq.interfaces.FunctionHandler {

	@Override
	public Map<String, Object> formSubmitHandler(FormFunctionRequest req) throws Exception {
		JSONObject values = req.getForm().getValues();

		ZCObject zcObj = ZCObject.getInstance();
		ZCTable table = zcObj.getTable("notes"); //NO I18N
		ZCRowObject row = ZCRowObject.getInstance();
		row.set("TITLE", values.get("title")); //NO I18N
		row.set("NOTE", values.get("note")); //NO I18N
		row.set("USER_ID", req.getUser().getId()); //NO I18N
		table.insertRow(row);

		MessageBuilder msg = MessageBuilder.getInstance();
		msg.setText("Note has been saved"); //NO I18N
		return ZCCliqUtil.toMap(msg);
	}

	@Override
	public Map<String, Object> buttonFunctionHandler(ButtonFunctionRequest req) throws Exception {
		return null;
	}

	@Override
	public FormChangeResponse formChangeHandler(FormFunctionRequest req) throws Exception {
		return null;
	}

	@Override
	public FormDynamicFieldResponse formDynamicFieldHandler(FormFunctionRequest req) throws Exception {
		return null;
	}

	@Override
	public Map<String, Object> widgetButtonHandler(WidgetFunctionRequest req) throws Exception {
		return null;
	}

}
