//$Id$
package com.handlers;

import java.util.Map;

import com.zc.cliq.enums.FORM_FIELD_TYPE;
import com.zc.cliq.objects.Form;
import com.zc.cliq.objects.FormActionsObject;
import com.zc.cliq.objects.FormInput;
import com.zc.cliq.objects.MessageBuilder;
import com.zc.cliq.requests.MessageActionHandlerRequest;
import com.zc.cliq.util.ZCCliqUtil;

public class MessageActionHandler implements com.zc.cliq.interfaces.MessageActionHandler {

	@Override
	public Map<String, Object> executionHandler(MessageActionHandlerRequest req) throws Exception {
		String text = "";
		String note = req.getMessage().getText().trim();

		if (note.isEmpty()) {
			text = "Nothing here to add note."; //NO I18N
		} else {
			return getForm(note);
		}

		MessageBuilder resp = MessageBuilder.getInstance();
		resp.setText(text);

		return ZCCliqUtil.toMap(resp);
	}

	private static Map<String, Object> getForm(String notes) {
		Form form = Form.getInstance();
		form.setTitle("Notes"); //NO I18N
		form.setHint("");
		form.setName("notes"); //NO I18N
		form.setButtonLabel("Save Note"); //NO I18N
		form.setVersion(1);

		FormActionsObject actions = FormActionsObject.getInstance();
		actions.setSubmitAction("storeNotes"); //NO I18N
		form.setActions(actions);

		FormInput title = FormInput.getIntance();
		title.setType(FORM_FIELD_TYPE.TEXT);
		title.setName("title"); //NO I18N
		title.setLabel("Title"); //NO I18N
		title.setHint("");
		title.setPlaceholder("Enter the note title"); //NO I18N
		title.setMandatory(true);
		form.addFormInput(title);

		FormInput note = FormInput.getIntance();
		note.setType(FORM_FIELD_TYPE.TEXTAREA);
		note.setName("note"); //NO I18N
		note.setLabel("Note"); //NO I18N
		note.setHint("");
		note.setPlaceholder("");
		note.setMandatory(true);
		note.setValue(notes);
		form.addFormInput(note);

		return ZCCliqUtil.toMap(form);
	}

}