'use strict'; // NO I18N

const cliq = require('zcatalyst-integ-cliq'); // NO I18N
const command = cliq.command();

command.executionHandler(async (req, res, app) => {
    let text;
    let suggestions = req.selections;
    if(suggestions === undefined || suggestions.length === 0) {
        text = 'Please select a suggestion from the command'; // NO I18N
    } else {
        let rowId = req.selections[0].id;
        const zcql = app.zcql();
        const query = `SELECT * FROM notes WHERE ROWID=${rowId}`;
        let rows = await zcql.executeZCQLQuery(query);
        let row = rows[0].notes;
        text = "*Title* : " + row.TITLE + " \n\n*Note* : " + row.NOTE; // NO I18N
    }
    res.setText(text);
    return res;
});

command.suggestionHandler(async (req, res, app) => {
        let userId = req.user.id;
        const zcql = app.zcql();
        const query = `SELECT * FROM notes WHERE USER_ID=${userId}`;
        let rows = await zcql.executeZCQLQuery(query);
        for(let row of rows)
        {
            let eachRow = row.notes;
            let suggestion = command.newCommandSugestion();
            suggestion.id = eachRow.ROWID;
            suggestion.title = eachRow.TITLE;
            suggestion.description = '';
            suggestion.imageurl = 'https://i.imgur.com/ereVzNU.png'; // NO I18N
            res.push(suggestion);
        }
        return res;
});