'use strict'; // NO I18N
const Cliq = require('zcatalyst-integ-cliq'); // NO I18N
const messageActionHandler = Cliq.messageAction();

messageActionHandler.executionHandler(async (req, res) => {
    let text = '';
    let note = req.message.text.trim() || "";
    if (note == "") {
        text = "Nothing here to add note."; // NO I18N
    } else {
        return getForm(note);
    }
    res.setText(text);
    return res;
});

function getForm(note) {
    const form = messageActionHandler.newHandlerResponse().newForm();
    form.title = 'Notes'; // NO I18N
    form.hint = '';
    form.name = 'notes';
    form.button_label = 'Save Note'; // NO I18N
    form.version = 1;

    const actions = form.newFormActionsObject();
    actions.submit = actions.newFormAction('storeNotes'); // NO I18N
    form.actions = actions;

    const noteName = form.newFormInput();
    noteName.type = 'text';
    noteName.name = 'title';
    noteName.label = 'Title'; // NO I18N
    noteName.hint = '';
    noteName.placeholder = 'Enter the note title'; // NO I18N
    noteName.mandatory = true;
    form.addInputs(noteName);

    const notes = form.newFormInput();
    notes.type = 'textarea';
    notes.name = 'note';
    notes.label = 'Note'; // NO I18N
    notes.hint = '';
    notes.placeholder = '';
    notes.value = note;
    notes.mandatory = true;
    form.addInputs(notes);

    return form;
}
