const CommonUtil = require("../utils/commonUtil");  //NO I18N
const DatabaseUtil = require("../utils/databaseUtil");  //NO I18N

const MessageActions = (function () {
    let reqData;
    const _handler = async (data) => {
        _inititalize(data);
        let response = {};
        if (reqData.handler.type === "execution_handler") {
            response = await _addTask();
        }
        return response;
    };

    const _inititalize = async (data) => {
        reqData = data;
    };

    const _addTask = async () => {

        const zuid = reqData.params.access.user_id;
        if (!(await DatabaseUtil.users.doesUserExists(zuid))) {
            await DatabaseUtil.users.addUser(zuid);
        }

        const isTokenAdded = await DatabaseUtil.users.isTokenAdded(zuid);
        if (!isTokenAdded) {
            return CommonUtil.getAuthButtonResponse();
        }

        const currentTask = await DatabaseUtil.tasks.getCurrentTask(zuid);
        if (currentTask !== null) {
            return CommonUtil.getBannerResponse(
                "Complete or pause your current task before starting a new task.",	//NO I18N
                true
            );
        }

        const messageText = reqData.params.messages.list[0].text;
        if (messageText.length < 3 || messageText.length > 100) {
            return CommonUtil.getBannerResponse(
                "Invalid message lenght",   //NO I18N
                true
            );
        }

        const projectsList = await DatabaseUtil.projects.getAllProjects(
            reqData.params.access.user_id
        );
        let projectOptions = [];
        let generalProjectId;
        projectsList.forEach((project) => {
            if (project.TITLE === "General") {
                generalProjectId = project.PROJECT_ID;
            }
            projectOptions.push({ label: project.TITLE, value: project.PROJECT_ID });
        });

        return {
            name: "addtask",    //NO I18N
            type: "form",   //NO I18N
            title: "Add Task",  //NO I18N
            hint: "",
            button_label: "Add",    //NO I18N
            inputs: [
                {
                    type: "text",   //NO I18N
                    name: "name",   //NO I18N
                    label: "Name",  //NO I18N
                    hint: "Enter the task name.",   //NO I18N
                    placeholder: "Work on state management",    //NO I18N
                    value: messageText,
                    min_length: "3",
                    max_length: "100",
                    mandatory: true
                },
                {
                    type: "select", //NO I18N
                    name: "project",    //NO I18N
                    label: "Project",   //NO I18N
                    hint: "Choose a project to add the task.",  //NO I18N
                    placeholder: "Select a project",    //NO I18N
                    value: generalProjectId,
                    options: projectOptions,
                    mandatory: true
                }
            ],
            action: { type: "invoke.function", name: "timetrackerform" }   //NO I18N
        };
    };

    return {
        handler: _handler
    };
    
})();

module.exports = MessageActions;