package UrlShortener.catalyst.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.catalyst.integ.CatalystIntegFunctionHandler;
import com.catalyst.integ.ZCIntegRequest;
import com.catalyst.integ.ZCIntegResponse;
import com.zc.cliq.util.ZCCliqUtil;

public class URLShortener implements CatalystIntegFunctionHandler {

	@Override
	public ZCIntegResponse runner(ZCIntegRequest req) throws Exception {
		ZCIntegResponse resp;
		try {
			resp = ZCCliqUtil.executeHandler(req);
			return resp;
		} catch (Exception ex) {
			resp = new ZCIntegResponse();
			resp.setContentType("application/json"); // NO I18N
			resp.setStatus(500);
			StringWriter stackStr = new StringWriter();
			ex.printStackTrace(new PrintWriter(stackStr));
			resp.setResponseBody("Exception: " + stackStr.toString()); // NO I18N
			return resp;
		}
	}
}
