//$Id$
package com.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.json.JSONObject;

import com.zc.api.APIConstants.RequestMethod;
import com.zc.api.APIRequest;
import com.zc.cliq.objects.CommandSuggestion;
import com.zc.cliq.requests.CommandHandlerRequest;

public class CommandHandler implements com.zc.cliq.interfaces.CommandHandler {

	@Override
	public Map<String, Object> executionHandler(CommandHandlerRequest req) throws Exception {

		Map<String, Object> resp = new HashMap<String, Object>();
		String text = "";
		String url = req.getArguments();

		if (url == null || url == "") {
			text = "Please provide the url along with this command. \nSyntax : /shortenurl <link>";
		} else {
			try {
				String shortenurl = getShortenedUrl(url);
				text = "Short URL : ```" + shortenurl + "```"; // NO I18N
			} catch (Exception e) {
				text = "Seems to be invalid URL."; // NO I18N
			}
		}
		resp.put("text", text);
		return resp;
	}

	private String getShortenedUrl(String url) throws Exception {
		APIRequest req = new APIRequest();
		req.setUrl("https://cleanuri.com/api/v1/shorten"); // NO I18N
		req.setRequestMethod(RequestMethod.POST);
		HashMap<String, Object> postData = new HashMap<String, Object>();
		postData.put("url", url);
		req.setPostData(postData);
		req.setAuthNeeded(false);
		JSONObject respJson = new JSONObject(req.getResponse().getResponseJSON().get(0).toString());
		String result_url = respJson.getString("result_url");
		return result_url;
	}

	@Override
	public List<CommandSuggestion> suggestionHandler(CommandHandlerRequest req) {
		return new ArrayList<CommandSuggestion>();
	}

}
